<?php



namespace App\Entity\Traits;



use Doctrine\DBAL\Types\Types;

use Doctrine\ORM\Mapping as ORM;

use Doctrine\ORM\Mapping\PrePersist;

use Doctrine\ORM\Mapping\PreUpdate;



trait TimestampsTrait

{

    /**

     * @var \DateTime

     */

    #[ORM\Column(name: "created_at", type: Types::DATETIME_MUTABLE, nullable: false)]

    private \DateTime $createdAt;



    /**

     * @var \DateTime

     */

    #[ORM\Column(name: "updated_at", type: Types::DATETIME_MUTABLE, nullable: false)]

    private \DateTime $updatedAt;



    public function getCreatedAt(): ?\DateTimeInterface

    {

        return $this->createdAt;

    }



    public function setCreatedAt(\DateTimeInterface $createdAt): self

    {

        $this->createdAt = $createdAt;



        return $this;

    }



    #[PrePersist]

    public function setCreatedAtValue()

    {

        $this->createdAt = new \DateTime();

    }



    public function getUpdatedAt(): ?\DateTimeInterface

    {

        return $this->updatedAt;

    }



    public function setUpdatedAt(\DateTimeInterface $updatedAt): self

    {

        $this->updatedAt = $updatedAt;



        return $this;

    }



    #[

        PrePersist,

        PreUpdate

    ]

    public function setUpdatedAtValue()

    {

        $this->updatedAt = new \DateTime();

    }

}

