<?php

// src/Enum/StatusEnum.php



namespace App\Entity\Enum;



enum TypeEnum: string

{

    case V = 'Villa';

    case S = 'Studio';

    case D = 'Duplex';



    // /**

    //  * Retourne toutes les valeurs de l'énumération.

    //  *

    //  * @return array

    //  */



    public static function getNames(): array

    {

        $choices = [];

        foreach (self::cases() as $case) {

            $choices[$case->name] = $case->value;

        }

        return $choices;

    }

    public static function getValues(): array

    {

        $choices = [];

        foreach (self::cases() as $case) {

            $choices[$case->value] = $case->name;

        }

        return $choices;

    }

    /**

     * Vérifie si une valeur donnée est une valeur valide de l'énumération.

     *

     * @param string $value

     * @return bool

     */

    public static function isValid(string $value): bool

    {

        return in_array($value, self::getValues(), true);

    }

}

