<?php

namespace App\Controller;

use App\Form\SearchPropertyType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class BaseController extends AbstractController
{
    protected function render(string $view, array $parameters = [], Response $response = null): Response
    {
        // Préparer le formulaire de recherche dans toutes les actions
        $parameters['searchForm'] = $this->createSearchForm()->createView();
        return parent::render($view, $parameters, $response);
    }

    private function createSearchForm(): FormInterface
    {
        return $this->createForm(SearchPropertyType::class);
    }
}
