<?php



namespace App\Form;



use App\Entity\Agence;

use App\Entity\Enum\CityEnum;

use App\Entity\Enum\TypeEnum;

use App\Entity\Property;

use App\Entity\Rental;

use App\Entity\User;

use Doctrine\ORM\EntityManagerInterface;

use Doctrine\ORM\EntityRepository;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;

use Symfony\Bundle\SecurityBundle\Security;

use Symfony\Component\Form\AbstractType;

use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

use Symfony\Component\Form\Extension\Core\Type\TextType;

use Symfony\Component\Form\FormBuilderInterface;

use Symfony\Component\OptionsResolver\OptionsResolver;



class SearchPropertyType extends AbstractType

{

    public function buildForm(FormBuilderInterface $builder, array $options)

    {



        $builder

            ->add('keywords', TextType::class, [

                'label' => 'Mot clé',

            ])

            ->add('type', ChoiceType::class, [

                'choices' => TypeEnum::getValues()

            ])

            ->add('bedrooms', EntityType::class, [

                'class' => Property::class,

                'choice_label' => function ($property) {

                    return $property->getRooms(); // Utilisation de la méthode getRooms() pour afficher le nombre de chambres

                },

                'query_builder' => function (EntityRepository $er) {

                    return $er->createQueryBuilder('p');

                },

                'placeholder' => '',

            ])

            ->add('bathrooms', EntityType::class, [

                'class' => Property::class,

                'choice_label' => function ($property) {

                    return $property->getBathrooms(); // Utilisation de la méthode getRooms() pour afficher le nombre de chambres

                },

                'query_builder' => function (EntityRepository $er) {

                    return $er->createQueryBuilder('p');

                },

                'placeholder' => '',

            ])

            ->add('parking', EntityType::class, [

                'class' => Property::class,

                'choice_label' => function ($property) {

                    return $property->getParking(); // Utilisation de la méthode getRooms() pour afficher le nombre de chambres

                },

                'query_builder' => function (EntityRepository $er) {

                    return $er->createQueryBuilder('p');

                },

                'placeholder' => '',

            ])

            ->add('city', ChoiceType::class, [

                'choices' => CityEnum::getValues()

            ])



            ->add('minPrice', EntityType::class, [

                'class' => Property::class,

                'choice_label' => function ($property) {

                    return $property->getSold(); // Utilisation de la méthode getRooms() pour afficher le nombre de chambres

                },

                'query_builder' => function (EntityRepository $er) {

                    return $er->createQueryBuilder('p');

                },

                'placeholder' => '',

            ]);

    }



    public function configureOptions(OptionsResolver $resolver)

    {

        $resolver->setDefaults([

            'method' => 'GET',

            'csrf_protection' => false,

        ]);

    }

}

