<?php

namespace App\Form;

use App\Entity\Enum\CityEnum;
use App\Entity\Prestation;
use App\Entity\Property;
use App\Entity\Enum\StatusEnum;
use App\Entity\Enum\TypeEnum;
use Doctrine\DBAL\Types\FloatType;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EnumType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PropertyType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        // dd($options['data']->getPrestations());
        $builder
            ->add('title', TextType::class, [
                'label' => 'Titre',
            ])
            ->add('description', TextType::class, [
                'label' => 'Description',
            ])
            ->add('surface', NumberType::class, [
                'label' => 'Surface',
            ])
            ->add('rooms', NumberType::class, [
                'label' => 'Nombre de chambres',
            ])
            ->add('bathrooms', NumberType::class, [
                'label' => 'Nombre de salle de bain',
            ])
            ->add('city', ChoiceType::class, [
                'choices' => CityEnum::getValues(),
            ])
            ->add('address', TextType::class, [
                'label' => 'Adresse',
            ])
            ->add('sold', NumberType::class, [
                'label' => 'Prix',
            ])
            ->add('parking', NumberType::class, [
                'label' => 'Places de parking',
            ])
            ->add('status', ChoiceType::class, [
                'choices' => TypeEnum::getValues(),
            ])
            ->add('type', ChoiceType::class, [
                'choices' => StatusEnum::getValues(),
            ])
            ->add('prestation', EntityType::class, [
                'class' => Prestation::class,
                // 'mapped' => false,
                'multiple' => true,
                'expanded' => true,
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('p')
                        ->orderBy('p.name', 'ASC');
                },
                'choice_label' => 'name',
                //'data'  => [3, 7, 1],
                'attr' => [
                    'class' => 'form-radio-inline',
                ]

            ])
            ->add('files', FileType::class, [
                'label' => false,
                'attr' => [
                    'class' => 'form-control',
                    'hidden' => true,
                    'accept' => '.png, .jpg, .jpeg', // Accepter uniquement les images
                    'data-max-size' => '3000000' // Taille maximale en octets (par exemple, 3MB)
                ],
                'multiple' => true,
                'mapped' => false,
                'required' => false,
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Property::class,
        ]);
    }
}
