<?php

namespace App\Controller;

use App\Entity\User;
use App\Repository\UserRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;

class SecurityController extends BaseController
{
    #[Route(path: '/login', name: 'app_login')]
    public function login(AuthenticationUtils $authenticationUtils, UserRepository $userRepository): Response
    {
        // Si un utilisateur est déjà connecté, redirigez-le vers la page d'accueil ou une autre page sécurisée
        // if ($this->getUser()) {
        //     return $this->redirectToRoute('app_home');
        // }

        // get the login error if there is one
        $error = $authenticationUtils->getLastAuthenticationError();

        // last username entered by the user
        $lastUsername = $authenticationUtils->getLastUsername();

        // Si l'utilisateur a saisi un email, vérifiez s'il est vérifié
        // if ($lastUsername) {
        //     // Récupérer l'utilisateur depuis la base de données par son email
        //     //$userRepository = $this->getDoctrine()->getRepository(User::class);
        //     $user = $userRepository->findOneBy(['email' => $lastUsername]);

        //     // Si l'utilisateur existe et n'est pas vérifié, afficher une erreur
        //     if ($user && !$user->isVerified()) {
        //         // Optionnel : envoyer un message flash pour informer l'utilisateur
        //         $this->addFlash('error', 'Votre compte n\'est pas vérifié.');

        //         // Rediriger ou renvoyer à une autre vue pour gérer cette situation
        //         return $this->redirectToRoute('verification_required');
        //         // Exemple d'une route fictive 'verification_required'
        //     }
        // }

        return $this->render('security/login.html.twig', [
            'last_username' => $lastUsername,
            'error' => $error,
        ]);
    }


    #[Route(path: '/logout', name: 'app_logout')]
    public function logout(): void
    {
        throw new \LogicException('This method can be blank - it will be intercepted by the logout key on your firewall.');
    }
}
