<?php

namespace App\Controller;

use App\Entity\Contact;
use App\Entity\Enum\CityEnum;
use App\Entity\Enum\StatusEnum;
use App\Entity\Enum\TypeEnum;
use App\Entity\Photo;
use App\Entity\Prestation;
use App\Entity\Property;
use App\Form\ContactType;
use App\Form\PropertyType;
use App\Repository\PropertyRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\File\Exception\FileException;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/property')]
class PropertyController extends BaseController
{
    #[Route('/', name: 'app_property_index', methods: ['GET'])]
    public function index(Request $request, PropertyRepository $propertyRepository, EntityManagerInterface $em, PaginatorInterface $paginator): Response
    {
        $biens = $propertyRepository->findAll();
        $properties = $paginator->paginate(
            $biens,
            $request->query->getInt('page', 1), // numéro de page
            10, // nombre d'éléments par page
            [
                'defaultSortFieldName' => 'start_date',
                'defaultSortDirection' => 'desc',
            ]
        );

        $latest_properties = $propertyRepository->findBy([], [], 2);
        //dd($latest_properties);
        return $this->render('property/index.html.twig', [
            'properties' => $properties,
            'latest_properties' => $latest_properties,
        ]);
    }

    #[Route('/agence', name: 'app_property_agence', methods: ['GET'])]
    public function agence(Request $request, PropertyRepository $propertyRepository, EntityManagerInterface $em, PaginatorInterface $paginator): Response
    {

        $agence = $this->getUser()->getAgence();


        $biens = $propertyRepository->findBy(['agence' => $agence->getId()]);

        $properties = $paginator->paginate(
            $biens,
            $request->query->getInt('page', 1), // numéro de page
            10, // nombre d'éléments par page
            [
                'defaultSortFieldName' => 'start_date',
                'defaultSortDirection' => 'desc',
            ]
        );
        // dd($agence, $biens);
        $latest_properties = $propertyRepository->findBy(['agence' => $agence->getId()], [], 4);
        //dd($latest_properties);
        return $this->render('property/index.html.twig', [
            'properties' => $properties,
            'latest_properties' => $latest_properties,
        ]);
    }

    #[Route('/new', name: 'app_property_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $property = new Property();
        $racine_directory = $this->getParameter('kernel.project_dir');
        $form = $this->createForm(PropertyType::class, $property);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $property->getUser($this->getUser());
            $entityManager->persist($property);
            $entityManager->flush();


            $photos = $form->get('files')->getData();
            $path = $racine_directory . '/var/files/property/photo/';
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }
            foreach ($photos as $photo) {
                if ($photo) {
                    $newFilename = uniqid() . '.' . $photo->guessExtension();
                    try {
                        $photo->move($path, $newFilename);
                        $photo_base = new Photo();
                        $photo_base->setFilepath($path . $newFilename);
                        $photo_base->setProperty($property);
                        $photo_base->setIsMain(false);
                        $entityManager->persist($photo_base);
                    } catch (FileException $e) {
                        $this->addFlash('error', 'Impossible d\'uploader le fichier.');
                    }
                }
            }
            return $this->redirectToRoute('app_property_agence', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('property/new.html.twig', [
            'property' => $property,
            'form' => $form,
        ]);
    }

    #[Route('/show/{id}', name: 'app_property_show', methods: ['GET', 'POST'])]
    public function show(Request $request, Property $property, EntityManagerInterface $em): Response
    {
        $contact = new Contact();
        $form = $this->createForm(ContactType::class, $contact);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $em->persist($contact);
            $em->flush();
            return $this->redirectToRoute('app_property_index', [], Response::HTTP_SEE_OTHER);
        }

        $racine_directory = $this->getParameter('kernel.project_dir');
        $path = $racine_directory . '/var/files/property/photo/' . $property->getId();
        if (is_dir($path)) {
            $photo_files = array_diff(scandir($path), ['.', '..']);
        } else {
            $photo_files = [];
        }

        return $this->renderForm('property/show.html.twig', [
            'form' => $form,
            'property' => $property,
            'types' => TypeEnum::getNames(),
            'cities' => CityEnum::getNames(),
            'statuses' => StatusEnum::getNames(),
            'photo_files' => $photo_files,
        ]);
    }

    #[Route('/edit/{id}', name: 'app_property_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Property $property, EntityManagerInterface $entityManager): Response
    {
        $racine_directory = $this->getParameter('kernel.project_dir');
        $form = $this->createForm(PropertyType::class, $property);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // $property = $data;
            //$property->setPrestations($data->getPrestations());

            $entityManager->flush();

            $photos = $form->get('files')->getData();

            $path = '/var/files/property/photo/';
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }
            foreach ($photos as $photo) {
                if ($photo) {
                    $newFilename = uniqid() . '.' . $photo->guessExtension();
                    try {
                        $photo->move($racine_directory . $path, $newFilename);
                        $photo_base = new Photo();
                        $photo_base->setFilepath($path . $newFilename);
                        $photo_base->setProperty($property);
                        $photo_base->setIsMain(false);
                        $entityManager->persist($photo_base);
                    } catch (FileException $e) {
                        $this->addFlash('error', 'Impossible d\'uploader le fichier.');
                    }
                }
            }
            $entityManager->flush();

            return $this->redirectToRoute('app_property_agence', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('property/edit.html.twig', [
            'property' => $property,
            'form' => $form,
        ]);
    }

    #[Route('/del/{id}', name: 'app_property_delete', methods: ['POST'])]
    public function delete(Request $request, Property $property, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete' . $property->getId(), $request->request->get('_token'))) {
            $entityManager->remove($property);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_property_index', [], Response::HTTP_SEE_OTHER);
    }

    #[Route('/readmainphoto/{filename}', name: 'app_property_readmainphotos', methods: ['GET', 'POST'])]
    public function readmainphotos(string $id, string $filename): Response
    {
        $racine_directory = $this->getParameter('kernel.project_dir');
        $path = $racine_directory . '/var/files/agence/' . $id . '/' . $filename;
        if (!file_exists($path)) {
            throw $this->createNotFoundException('Le fichier n\'existe pas');
        }

        $response = new BinaryFileResponse($path);
        $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_INLINE, $filename);

        return $response;
    }

    #[Route('/readphoto', name: 'app_property_readphoto', methods: ['GET', 'POST'])]
    public function readphotos(Request $request): Response
    {
        $path = $request->get('path');
        $racine_directory = $this->getParameter('kernel.project_dir');
        $file = $racine_directory . '/' . $path;
        //dd($file);
        if (!file_exists($file)) {
            // $this->addFlash('error', 'Le fichier n\'existe pas.');
            throw $this->createNotFoundException('Le fichier n\'existe pas');
        }

        $response = new BinaryFileResponse($file);
        // $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_INLINE, $file);
        return $response;
    }


    #[Route('/deletefile', name: 'app_property_deletefile', methods: ['GET', 'POST'])]
    public function deleteFile(Request $request, EntityManagerInterface $entityManager): Response
    {
        $path = $request->get('path');
        $referer = $request->headers->get('referer');
        $racine_directory = $this->getParameter('kernel.project_dir');
        $file = $racine_directory . $path;

        $photo = $entityManager->getRepository(Photo::class)->findOneBy(['filepath' => $path]);
        $entityManager->remove($photo);
        $entityManager->flush();

        if (file_exists($file)) {
            unlink($file);
            $this->addFlash('success', 'Fichier supprimé avec succès.');
        } else {
            $this->addFlash('error', 'Le fichier n\'existe pas.');
        }
        return $this->redirect($referer);
    }
}
