<?php

namespace App\Controller;

use App\Entity\Enum\CityEnum;
use App\Entity\Enum\TypeEnum;
use App\Entity\Property;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Doctrine\ORM\EntityManagerInterface;


class HomeController extends BaseController
{
    #[Route('/', name: 'app_home')]
    public function index(EntityManagerInterface $em): Response
    {
        $properties = $em->getRepository(Property::class)->findAll();
        $latest_properties = $em->getRepository(Property::class)->findBy([], ['createdAt' => 'DESC'], 3);

        return $this->render('home/index.html.twig', [
            'properties' => $properties,
            'latest_properties' => $latest_properties,
            'types' => TypeEnum::getNames(),
            'cities' => CityEnum::getNames(),
        ]);
    }

    #[Route('/about', name: 'app_about')]
    public function about(): Response
    {
        return $this->render('home/about.html.twig', []);
    }
}
