let allFiles = [];
let nb_photos = document.getElementById('nb_photos').value;
const fileInput = document.querySelector('input[name="property[files][]"]');
const dataTransfer = new DataTransfer();
const MAX_FILES = 5;
const nb_restant = MAX_FILES - nb_photos;
function addFiles() {
    const tempFileInput = document.createElement('input');
    tempFileInput.type = 'file';
    tempFileInput.multiple = true;
    tempFileInput.classList.add('form-control');
    tempFileInput.setAttribute('accept', '.png, .jpg, .jpeg');

    const maxSize = parseInt(fileInput.getAttribute('data-max-size'));
    const allowedTypes = ['image/png', 'image/jpg', 'image/jpeg'];

    tempFileInput.onchange = function() {
        const newFiles = tempFileInput.files;
        if (allFiles.length + newFiles.length > nb_restant) {
            alert('Vous ne pouvez pas télécharger plus de ' + MAX_FILES + ' fichiers.');
            return;
        }

        for (let i = 0; i < newFiles.length; i++) {
            const file = newFiles[i];

            // Vérification du type de fichier
            if (!allowedTypes.includes(file.type)) {
                alert('Le fichier ' + file.name + ' n\'est pas un type de fichier valide. Seuls les fichiers PNG, JPG et JPEG sont autorisés.');
                return;
            }

            // Vérification de la taille du fichier
            if (file.size > maxSize) {
                alert('Le fichier ' + file.name + ' est trop volumineux. La taille maximale est de ' + (maxSize / 1000000) + ' MB.');
                return;
            }

            allFiles.push(file);
            dataTransfer.items.add(file);
            fileInput.files = dataTransfer.files;

            // previewImage(file);
        }
        updateFileList();
    };

    tempFileInput.click();
}

function updateFileList() {
    const fileList = document.getElementById('file-list');
    fileList.innerHTML = '';
    allFiles.forEach((file, index) => {
        const col = document.createElement('div');
        col.className="col-md-4";
        const divImgCont = document.createElement('div');
        divImgCont.className="image-container";

        col.appendChild(divImgCont);
        fileList.appendChild(col);




        //div.textContent = file.name;

        const reader = new FileReader();
        reader.onload = function(e) {
            const img = document.createElement('img');
            // img.className="img-fluid"
            img.src = e.target.result;
            // img.style.maxWidth = '100px';
            // img.style.margin = '10px';
            divImgCont.appendChild(img);


        };
        reader.readAsDataURL(file);

        const removeButton = document.createElement('button');
        removeButton.className='bi bi-trash btn-bottom-right';
        removeButton.textContent = '';
        removeButton.title = 'Supprimer';
        removeButton.onclick = () => removeFile(index);
        divImgCont.appendChild(removeButton);
 
    });
}

function previewImage(file) {
    const reader = new FileReader();
    reader.onload = function(e) {

        const img = document.createElement('img');
        img.src = e.target.result;
        img.style.maxWidth = '200px';
        img.style.margin = '10px';

        document.getElementById('preview-container').appendChild(img);

    };
    reader.readAsDataURL(file);
}

function removeFile(index) {
    allFiles.splice(index, 1);
    const newDataTransfer = new DataTransfer();
    allFiles.forEach(file => {
        newDataTransfer.items.add(file);
    });
    fileInput.files = newDataTransfer.files;

    updateFileList();
    // updatePreviewContainer();
}

function updatePreviewContainer() {
    const previewContainer = document.getElementById('preview-container');
    previewContainer.innerHTML = '';
    allFiles.forEach(file => {
        previewImage(file);
    });
}

// Ajoutez un conteneur pour les prévisualisations dans votre HTML
// <div id="preview-container"></div>
